﻿var interviewerQuotas = {
    inPercent: $("#InPercent").val() == "True",
    context: $(".v-interviewerQuotas"),
    treeview: null,
    datatable: null,
    initializeTreeView: function () {
        var actionButtons = [];

        if (voxco.security.has('MODIFY')) {
            actionButtons = [
                { Action: "copyfrom", Label: resources.CopyStrataFrom, Icon: "copy", "DisplayCondition": function (data) { return data.Type == 'user'; } },
                { Action: "copyInterviewerQuotas", Label: resources.CopyTo, Icon: "copy", "DisplayCondition": function (data) { return data.Id != null; } }
            ];
        }

        interviewerQuotas.treeview = $(".h-userGroups", this.context).a4listview({
            ajaxAction: a4.getProjectAction("GetUserGroupsAndUsers", "Quotas"),
            customItems: [
                { Action: "all", Name: resources.All },
            ],
            altValueField: $("#InterviewerId"),
            icons: {
                Node: null,
                Leaf: "user"
            },
            properties: {
                Children: "Users"
            },
            selectNode: function (event, data) {
                interviewerQuotas.refreshTable(data);
            },
            actionButtons: actionButtons,
            actionButtonClick: function (event, data) {
                var action = data.action;
                var node = data.node;

                switch (action) {
                    case "copyfrom":
                        modalDialog.showWindow(a4.getProjectAction("CopyUserStrata", "Offline", { userId: node.Id }), 400, 500, { afterClose: function () { interviewerQuotas.refreshContent(); } });
                        break;

                    case "copyInterviewerQuotas":
                        modalDialog.showWindow(a4.getProjectAction("CopyInterviewerQuotas", "Quotas", { interviewerId: node.Id, interviewerName: node.Name }), 800, 1000, { afterClose: function () { interviewerQuotas.refreshContent(); } });
                        break;
                }
            },
            draw: function (event, data) {
                if (interviewerQuotas.datatable) {
                    interviewerQuotas.refreshTable(data);
                }
                else {
                    interviewerQuotas.initializeDataTable();
                }
            },
            localizableTexts: { "Search": resources.SearchInterviewers }
        });
    },
    initializeDataTable: function () {
        var toolBarItems = [];
        var contextMenuItems = [];

        if (voxco.security.has('MODIFY')) {
            toolBarItems = [
                { "Action": "open", "Label": resources.Open, "DisplayCondition": function (data) { return data.Status != 2; } },
                { "Action": "close", "Label": resources.Close, "DisplayCondition": function (data) { return data.Status != 2; } }
            ];

            contextMenuItems = [
                { "Action": "properties", "Label": resources.Properties },
                { "Divider": true },
                { "Action": "open", "Label": resources.Open, "DisplayCondition": function (data) { return data.Status == 'Closed'; } },
                { "Action": "close", "Label": resources.Close, "DisplayCondition": function (data) { return data.Status == 'Open'; } }
            ];
        }

        this.datatable = $(".h-interviewerQuotasTable", interviewerQuotas.context).a4datatable({
            advancedFilter: true,
            stateKey: "InterviewerQuotas",
            ajaxAction: a4.getProjectAction("GetInterviewersQuotas", "Quotas"),
            ajaxParams: { "ProjectId": $("#ProjectId").val(), "userOrGroupId": 0 },
            columns: [
                { "Name": "QuotaId", "Data": "QuotaId", "Visible": false, "HideInSelector": true },
                { "Name": "Name", "Title": resources.User },
                { "Name": "Stratum", "Title": resources.Stratum },
                { "Name": "Status", "Data": "StatusEnum", "Title": resources.Status, "Type": "enum", "EnumType": "QuotaStatus", "Editable": { "DisplayCondition": voxco.security.has('MODIFY'), "Nullable": false } },
                { "Name": "Label", "Title": resources.Label },
                { "Name": "Criterion", "Title": resources.Criterion },
                { "Name": "ProjectQuota", "Title": resources.ProjectQuota },
                { "Name": "ProjectFrequency", "Title": resources.ProjectFrequency },
                { "Name": "ProjectTodo", "Title": resources.ToDo },
                { "Name": "InterviewerQuota", "Title": resources.InterviewersQuota, "Type": "numeric", "Editable": voxco.security.has('MODIFY') },
                { "Name": "InterviewerFrequency", "Title": resources.InterviewersFrequency }
            ],
            allowRowSelection: false,
            localizableTexts: { "All": resources.AllStrata, "Search": resources.SearchStrata },
            toolBarItems: toolBarItems,
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;

                switch (action) {
                    case "open":
                        interviewerQuotas.updateStatus(rows, 0);
                        break;
                    case "close":
                        interviewerQuotas.updateStatus(rows, 2);
                        break;
                };
            },
            contextMenuItems: contextMenuItems,
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "open":
                        interviewerQuotas.updateInterviewerQuotaStatus(row.Id, row.QuotaId, 0);
                        break;
                    case "close":
                        interviewerQuotas.updateInterviewerQuotaStatus(row.Id, row.QuotaId, 2);
                        break;
                    case "properties":
                        modalDialog.showWindow(a4.getProjectAction("EditInterviewerQuota", "Quotas", { projectId: $("#ProjectId").val(), interviewerId: row.Id, quotaId: row.QuotaId }), 400, null, { afterClose: function () { interviewerQuotas.refreshContent(true); } });
                        break;
                }
            },
            quickFilter: {
                "Items": [
                    { "Label": resources.StatusOpen, "AjaxParams": { "status": 0 } },
                    { "Label": resources.StatusClosed, "AjaxParams": { "status": 2 } }
                ]
            },
            multiEdit: voxco.security.has('MODIFY'),
            rowUpdated: function (even, data) {
                interviewerQuotas.datatable.a4datatable("updateItem", data.index, { ProjectQuota: 4, ProjectFrequency: 7 });
            },
            rowsUpdated: function (event, data) {
                a4.callServerMethod(a4.getProjectAction("UpdateInterviewerQuota", "Quotas"), { interviewerQuota: data.rows }, function () {
                    data.multiEditSaveCallback();
                });
            },
            cellCreated: function (evt, data) {
                if (data.fieldName == "Status")
                    $(data.cell).addClass("stratum-status-" + data.row.Status);

            }
        });
    },
    refreshContent: function () {
        interviewerQuotas.treeview.a4listview("refresh");
    },
    refreshTable: function (treeViewData) {
        var tableParams = interviewerQuotas.getTreeviewParam(treeViewData);

        interviewerQuotas.datatable.a4datatable("option", "ajaxParams", tableParams);
        interviewerQuotas.datatable.a4datatable("refresh", true);
    },
    bindEvents: function () {
        this.context.on("click", ".h-exportExcel", function () {
            interviewerQuotas.exportToFile(false);
        });
        this.context.on("click", ".h-exportCsv", function () {
            interviewerQuotas.exportToFile(true);
        });

        this.context.on("click", ".h-importQuotas", function () {
            modalDialog.showWindow(a4.getProjectAction("ImportInterviewersQuotasFromCSV", "Quotas", { projectId: $("#ProjectId").val() }), 460, 500, {
                afterClose: function () {
                    interviewerQuotas.refreshContent(true);
                }
            });
        });

    },
    updateStatus: function (status) {
        var tableParams = interviewerQuotas.getTreeviewParam();
        tableParams.status = status;

        interviewerQuotas.datatable.a4datatable("option", "ajaxParams", tableParams);
        interviewerQuotas.datatable.a4datatable("refresh", true);
    },
    updateInterviewerQuotaStatus: function (interviewerId, quotaId, status) {
        var params = {};
        params.projectId = $("#ProjectId").val();
        params.interviewerId = interviewerId;
        params.quotaId = quotaId;
        params.status = status;

        a4.callServerMethod(a4.getProjectAction("UpdateInterviewerQuotaStatus", "Quotas"), params, function () {
            interviewerQuotas.refreshContent();
        });
    },
    getTreeviewParam: function (treeViewData) {
        var tableParams = {};

        if (treeViewData == false)
            treeViewData = treeview;

        if (treeViewData.isCustom) {
            tableParams.userOrGroup = null;
            tableParams.userOrGroupId = null;
        }
        else if (treeViewData.node) {
            tableParams.userOrGroup = treeViewData.node.Type;
            tableParams.userOrGroupId = treeViewData.node.Id;
        }

        return tableParams;
    },
    exportToFile: function (toCSV) {
        var tableParams = interviewerQuotas.datatable.a4datatable("getTableParams");
        var columns = interviewerQuotas.datatable.a4datatable("getVisibleColumns");
        var node = interviewerQuotas.treeview.a4listview("getHighlightedNode");

        var params = {};
        params.userOrGroup = node != null ? node.Type : null;
        params.userOrGroupId = node != null ? node.Id : 0;

        var extFilename = toCSV ? "csv" : "xls";

        var data = {
            tableParams: tableParams,
            columns: columns.join(),
            userOrGroupId: params.userOrGroupId,
            userOrGroup: params.userOrGroup,
            status: null,
            toCSV: toCSV
        };

        a4.showBusyBox();
        a4.callServerMethod(a4.getProjectAction("ExportInterviewerQuotas", "Quotas"), data, function (result) {
            a4.hideBusyBox();
            window.location = a4.getProjectAction("GetInterviewerQuotasFile", "Quotas", { filePath: result, fileName: "InterviewerQuotas." + extFilename });
        });
    }
}

$(document).ready(function () {
    if (interviewerQuotas.context.length > 0) {
        interviewerQuotas.initializeTreeView();
        interviewerQuotas.bindEvents();
    }
});